import requests
from bs4 import BeautifulSoup

# fetch_emoji_data_file

import requests

def fetch_unicode_emoji_data(url):
  # URL of the emoji test data
  # url = "https://unicode.org/Public/emoji/11.0/emoji-test.txt"
  # url = "https://unicode.org/Public/emoji/12.0/emoji-test.txt"
  # url = "https://unicode.org/Public/emoji/13.0/emoji-test.txt"
  # url = "https://unicode.org/Public/emoji/14.0/emoji-test.txt"      
  # url = "https://demo.razzi.my/bigdata/unicode.org_Public_emoji_11.0_emoji-test.txt"
  # url = "https://demo.razzi.my/bigdata/unicode.org_Public_emoji_12.0_emoji-test.txt"
  # url = "https://demo.razzi.my/bigdata/unicode.org_Public_emoji_13.0_emoji-test.txt"
  # url = "https://demo.razzi.my/bigdata/unicode.org_Public_emoji_14.0_emoji-test.txt"

  list_emoji_data = []

  # Send a GET request to fetch the data
  response = requests.get(url)

  # Check if the request was successful
  if response.status_code == 200:
      # Get the text content and ensure it's in UTF-8 encoding
      response.encoding = 'utf-8'
      data = response.text

      # Initialize variables to hold parsed data

      current_group = None
      current_subgroup = None

      # Split the data into lines
      for line in data.splitlines():
          line = line.strip()  # Remove leading/trailing whitespace

          # Check for group
          if line.startswith("# group:"):
              current_group = line.split(":")[1].strip().replace(" ", "") 

          
          # Check for subgroup
          elif line.startswith("# subgroup:"):
              current_subgroup = line.split(":")[1].strip().replace("-", ".") 

          # Check for emoji entries
          elif current_group and line and not line.startswith("#"):
              # Append a tuple of (group, subgroup, emoji entry) to the list
              #print(line)
              list_emoji_data.append((current_group, 
                                      current_subgroup, 
                                      line.split(';')[0].strip(), 
                                      line.split(';')[1].split('#')[1].strip().split(' ')[0],
                                      line.split(';')[1].split('#')[1].strip().replace(line.split(';')[1].split('#')[1].strip().split(' ')[0],'').strip()
                                      ))

      # Print the extracted data (for demonstration purposes)
      # for group, subgroup, text in list_emoji_data:
      #     print(f"Group: {group}, Subgroup: {subgroup}, Text: {text}")
      # print(list_emoji_data)

  else:
      print(f"Failed to fetch data. Status code: {response.status_code}")

  return list_emoji_data



def fetch_emojipedia_data(url):
  # URL of the emoji test data
  # url = "https://emojipedia.org/unicode-6.0"
  # url = "https://emojipedia.org/unicode-7.0"
  # url = "https://emojipedia.org/unicode-8.0"
  # url = "https://emojipedia.org/unicode-9.0"      
  # url = "https://emojipedia.org/unicode-10.0"
  # url = "https://emojipedia.org/unicode-11.0"
  # url = "https://emojipedia.org/unicode-12.0"
  # url = "https://emojipedia.org/unicode-13.0"

  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-06.0.html"
  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-07.0.html"
  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-08.0.html"
  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-09.0.html"
  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-10.0.html"
  # url = "https://demo.razzi.my/bigdata/emojipedia.org!unicode-11.0.html"


  list_emoji_data = []

  # Send a GET request to fetch the data
  response = requests.get(url)

  # Check if the request was successful
  if response.status_code == 200:
      # Get the text content and ensure it's in UTF-8 encoding
      response.encoding = 'utf-8'

      # Parse the content with BeautifulSoup
      soup = BeautifulSoup(response.content, 'html.parser')

      # Find the container with the emojis
      container = soup.find('div', class_='EmojisList_emojis-list-wrapper__A8gKQ')

      # Extract all the anchor tags within the container
      emoji_items = container.find_all('a', class_='Link_link-wrapper__C33u_ Emoji_emoji__6sYSR __variable_e5a5aa EmojisList_emojis-list-item__MGP6t')

      list_emoji_data = []
      # Loop through each anchor tag and extract emoji and name
      for item in emoji_items:
          emoji = item.contents[0].strip() if item.contents else ''
          name = item.find('span', class_='EmojisList_emojis-list-item-title__kiHdi').text.strip()
          #print(f"{emoji} - {name}")
          list_emoji_data.append((emoji,name))


  else:
      print(f"Failed to fetch data. Status code: {response.status_code}")

  return list_emoji_data